function [Mxc,Nxc] = bfor_endogenous_ms_solver_matrices_xc(nderivs, that, Pmatss, H, G, G2)
% 
% Returns the matrices Mxc and Nxc for solving the second order derivative
%   with respect to xlag, chi
% 
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
%  INPUTS
%  nderivs  = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state  
%  that     = (ntheta x ns matrix) of theta-hat, the deviation of theta_s 
%               from thetabar
%  Pmatss   = (ns x ns) matrix of the transition matrix at steady state
%  H        = (nx x (nx+ne+1) x ns) array for first-order solution for the 
%               predetermined variables, H(i,j,s) is the response of x(i) 
%               to state(j) given regime s, state=[xlag;epsilon;chi]
%  G        = (ny x (nx+ne+1) x ns) array for first-order solution for the 
%               non-predetermined variables, G(i,j,s) is the response of 
%               y(i) to state(j) given regime s, state=[xlag;epsilon;chi]
%  G2       = (ny x (nx+ne+1)^2 x ns) array for second-order solution for 
%               the non-predetermined variables, G2(i,j,s) is the response 
%               of y(i) to the j-element of kron(state,state) conditional 
%               on regime s
%  
%  OUTPUTS
%   Mxc     = {ns x ns) cell of derivative coefficients for solving the
%               system
%   Nxc     = {ns x ns) cell of constants for solving the system
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

% -- Other Setup -- %
ny  = size(G,1);
nx  = size(H,1);
ne  = size(H,2)-nx-1;
ns  = length(Pmatss);
n   = nx + ny;
Mxc = cell(ns,ns);
Nxc = cell(ns,ns);

dPy = nderivs.dPy;

for s = 1:ns
    for sp = 1:ns
        dfyp          = nderivs.dfyp{sp,s};
        dfy           = nderivs.dfy{sp,s};
        dfx           = nderivs.dfx{sp,s};
        dfxlag        = nderivs.dfxlag{sp,s};
        dftp          = nderivs.dftp{sp,s};
        dft           = nderivs.dft{sp,s};
        dfypyp        = nderivs.dfypyp{sp,s};
        dfypy         = nderivs.dfypy{sp,s};
        dfypx         = nderivs.dfypx{sp,s};
        dfypxlag      = nderivs.dfypxlag{sp,s};
        dfyptp        = nderivs.dfyptp{sp,s};
        dfypt         = nderivs.dfypt{sp,s};
        dfyy          = nderivs.dfyy{sp,s};
        dfyx          = nderivs.dfyx{sp,s};
        dfyxlag       = nderivs.dfyxlag{sp,s};
        dfytp         = nderivs.dfytp{sp,s};
        dfyt          = nderivs.dfyt{sp,s};
        dfxx          = nderivs.dfxx{sp,s};
        dfxxlag       = nderivs.dfxxlag{sp,s};
        dfxtp         = nderivs.dfxtp{sp,s};
        dfxt          = nderivs.dfxt{sp,s};
        dfxlagtp      = nderivs.dfxlagtp{sp,s};
        dfxlagt       = nderivs.dfxlagt{sp,s};
        
        
        Mxc{sp,s} = Pmatss(s,sp)*[kron(eye(nx),dfx+dfyp*G(:,1:nx,sp)) kron(eye(nx),dfy) zeros(n*nx,nx*ny)];
        for ii = 1:nx
            Mxc{sp,s}((ii-1)*n+1:ii*n,n*nx+1:end) = Pmatss(s,sp)*kron(H(:,ii,s)',dfyp);
        end
        
        Nxc{sp,s} = zeros(n*nx,1);
        for bb = 1:nx
            for aa = 1:n
                loc = (bb-1)*n + aa;
                Nxc{sp,s}(loc) = 0;          
                for ii = 1:ny  
                    Nxc{sp,s}(loc) = Nxc{sp,s}(loc) ...
                        + Pmatss(s,sp)*(reshape(dfypyp(aa,ii,:),1,[])*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp)) + reshape(dfypy(aa,ii,:),1,[])*G(:,nx+ne+1,s) + reshape(dfypx(aa,ii,:),1,[])*H(:,nx+ne+1,s) + reshape(dfyptp(aa,ii,:),1,[])*that(:,sp) + reshape(dfypt(aa,ii,:),1,[])*that(:,s))*G(ii,1:nx,sp)*H(:,bb,s) ...
                        + Pmatss(s,sp)*(reshape(dfypy(aa,:,ii),1,[])*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp))  + reshape(dfyy(aa,ii,:),1,[])*G(:,nx+ne+1,s)  + reshape(dfyx(aa,ii,:),1,[])*H(:,nx+ne+1,s)  + reshape(dfytp(aa,ii,:),1,[])*that(:,sp)  + reshape(dfyt(aa,ii,:),1,[])*that(:,s))*G(ii,bb,s);
                end
                for ii = 1:nx
                   Nxc{sp,s}(loc) = Nxc{sp,s}(loc) ...
                       + Pmatss(s,sp)*(reshape(dfypx(aa,:,ii),1,[])*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp)) + reshape(dfyx(aa,:,ii),1,[])*G(:,nx+ne+1,s) + reshape(dfxx(aa,:,ii),1,[])*H(:,nx+ne+1,s) + reshape(dfxtp(aa,ii,:),1,[])*that(:,sp)  + reshape(dfxt(aa,ii,:),1,[])*that(:,s))*H(ii,bb,s) ...
                       + Pmatss(s,sp)*(dfyp(aa,:)*G2(:,(ii-1)*(nx+ne+1)+1:(ii-1)*(nx+ne+1)+nx,sp)*H(ii,bb,s)*H(:,nx+ne+1,s));
                end
                Nxc{sp,s}(loc) = Nxc{sp,s}(loc) ...
                    + Pmatss(s,sp)*(reshape(dfypxlag(aa,:,bb),1,[])*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp)) + dfyxlag(aa,:,bb)*G(:,nx+ne+1,s) + dfxxlag(aa,:,bb)*H(:,nx+ne+1,s) + reshape(dfxlagtp(aa,bb,:),1,[])*that(:,sp) + reshape(dfxlagt(aa,bb,:),1,[])*that(:,s)) ...
                    + shiftdim(dPy(s,sp,:),1)*G(:,nx+ne+1,s)*(dfyp(aa,:)*G(:,1:nx,sp)*H(:,bb,s) + dfy(aa,:)*G(:,bb,s) + dfx(aa,:)*H(:,bb,s) + dfxlag(aa,bb)) ...
                    + shiftdim(dPy(s,sp,:),1)*G(:,bb,s)*(dfyp(aa,:)*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp)) + dfy(aa,:)*G(:,nx+ne+1,s) + dfx(aa,:)*H(:,nx+ne+1,s) + dftp(aa,:)*that(:,sp) + dft(aa,:)*that(:,s));
            end
        end        
    end
end